package com.tomas.ht_ydt.Adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;


import com.tomas.ht_ydt.ListData.ItemStock_list;
import com.tomas.ht_ydt.R;

import java.text.DecimalFormat;
import java.util.List;

public class ItemStock_Adapter extends RecyclerView.Adapter<ItemStock_Adapter.ViewHolder> {
    private List<ItemStock_list> data;
    Context context;
    DecimalFormat decimalFormat;

    public ItemStock_Adapter(List<ItemStock_list> data, Context context) {
        this.data = data;
        this.context = context;
    }

    public class ViewHolder extends RecyclerView.ViewHolder{
        LinearLayout layout;
        TextView txt_index, txt_location, txt_box, txt_qty, txt_lot_no;
        public ViewHolder(View itemview){
            super(itemview);
            layout = (LinearLayout) itemview.findViewById(R.id.item_row);
            txt_index = (TextView)itemView.findViewById(R.id.txt_index);
            txt_lot_no = (TextView)itemView.findViewById(R.id.txt_lot_no);
            txt_location = (TextView)itemView.findViewById(R.id.txt_location);
            txt_box = (TextView)itemView.findViewById(R.id.txt_box);
            txt_qty = (TextView)itemView.findViewById(R.id.txt_qty);
        }
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View content_view = LayoutInflater.from(parent.getContext()).inflate(R.layout.content_stock,parent,false);
        context = parent.getContext();
        return new ViewHolder(content_view);
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        decimalFormat = new DecimalFormat("#,##0.00");
        final  ItemStock_list item = data.get(position);
        holder.txt_index.setText(item.getId());
        holder.txt_lot_no.setText(item.getLot_no());
        holder.txt_location.setText(item.getLocation());
        holder.txt_box.setText(item.getBox());
        holder.txt_qty.setText(decimalFormat.format(Double.parseDouble(item.getQty())));
    }

    @Override
    public int getItemCount() {
        return data.size();
    }
}
